<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use Laravel\Passport\Passport;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     */
    protected $policies = [
        // Add your model policies here
    ];

    /**
     * Register any authentication / authorization services.
     */
    public function boot(): void
    {
        $this->registerPolicies(); // Move it here

        // Ensures Passport is working
        //  Passport::routes();

        // Set token expiry to 1 days
        Passport::personalAccessTokensExpireIn(now()->addDays(1));

        // Optional: set refresh token expiry
        Passport::refreshTokensExpireIn(now()->addDays(2));
    }
}
