<?php
namespace App\Traits;

use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;

trait LogisticsHttpClientTrait
{
    /**
     * Send a POST request to the logistics API.
     *
     * @param string $url The API endpoint URL.
     * @param array $headers The headers for the request.
     * @param string $body The body content (usually JSON or form-data).
     * @return string The response body.
     */
    public function sendPostRequest(string $url, array $headers, string $body): string
    {
        $client = new Client();

        try {
            $response = $client->post($url, [
                'headers' => $headers,
                'body' => $body,
                'verify' => false,  // Disable SSL verification (use only in dev/test)
            ]);

            // dd($response->getBody()->getContents());

            return $response->getBody()->getContents();
        } catch (GuzzleException $e) {
            return 'Error: ' . $e->getMessage();
        }
    }

    /**
     * Send a GET request to the logistics API.
     *
     * @param string $url The API endpoint URL.
     * @param array $headers The headers for the request.
     * @return string The response body.
     */
    public function sendGetRequest(string $url, array $headers): string
    {
        $client = new Client();

        try {
            $response = $client->get($url, [
                'headers' => $headers,
            ]);

            return $response->getBody()->getContents();
        } catch (GuzzleException $e) {
            return 'Error: ' . $e->getMessage();
        }
    }
}
