<?php

namespace App\Services\Logistics;

use App\Services\Logistics\Providers\DelhiveryService;
use App\Services\Logistics\Providers\FedExService;
use App\Services\Logistics\Providers\DHLService;
use App\Services\Logistics\Providers\UpsService;

class LogisticsFactory
{
    // public static function getProvider($provider)
    // {
    //     return match (strtolower($provider)) {
    //         'fedex' => new FedExService(),
    //         'ups' => new UpsService(),
    //         'dhl'   => new DHLService(),
    //         default => throw new \Exception("Invalid Logistics Provider"),
    //     };
    // }
    public static function getProviderNames(): array
    {
        return [
            'fedex',
            'delhivery',
            // 'ups',
            // 'dhl',
        ];
    }

    public static function getAllShippingCosts(array $packageDetails, array $providerNames): array
    {
        $allProviders = array_change_key_case(self::getAllProviders(), CASE_LOWER);
        $shippingOptions = [];

        foreach ($providerNames as $name) {
            $key = strtolower($name);

            if (isset($allProviders[$key])) {
                $shippingOptions[] = $allProviders[$key]->calculateShippingCost($packageDetails);
            }
        }

        // foreach ($allProviders as $provider) {
        //     $shippingOptions[] = $provider->calculateShippingCost($packageDetails);
        // }

        return $shippingOptions;
    }
    public static function getAllProviders()
    {
        // Assuming you have multiple logistics providers configured
        return [

            'FedEx' => new FedExService(),
            'delhivery' => new DelhiveryService(),
            // 'UPS' => new UpsService(),
            // 'DHL' => new DHLService(),
        ];
    }

    public static function availablityCheck(array $options): array
    {
        $providers = self::getAllProviders();
        $availgOptions = [];

        foreach ($providers as $provider) {
            $availgOptions[] = $provider->availablityCheck($options);
        }

        return $availgOptions;
    }

    public static function checkPickupAvailability(array $options): array
    {
        $providers = self::getAllProviders();
        $availgOptions = [];

        foreach ($providers as $provider) {
            $availgOptions[] = $provider->checkPickupAvailability($options);
        }

        return $availgOptions;
    }

    public static function createShipment(array $options, string $provider): array
    {
        $providers = self::getAllProviders();
        $availgOptions = [];

        foreach ($providers as $key => $providerInstance) {
            if (strtolower($key) === strtolower($provider)) {
                $availgOptions[] = $providerInstance->createShipment($options);
                return $availgOptions;
            }
        }

        return [
            'status' => 'error',
            'message' => "Provider '$provider' not found.",
        ];
    }

    public static function createPickup(array $options, string $provider): array
    {
        $providers = self::getAllProviders();
        $availgOptions = [];

        foreach ($providers as $key => $providerInstance) {
            if (strtolower($key) === strtolower($provider)) {
                $availgOptions[] = $providerInstance->createPickup($options);
                return $availgOptions;
            }
        }

        return [
            'status' => 'error',
            'message' => "Provider '$provider' not found.",
        ];
    }

    public static function cancelPickup(array $options, string $provider): array
    {
        $providers = self::getAllProviders();
        $availgOptions = [];

        foreach ($providers as $key => $providerInstance) {
            if (strtolower($key) === strtolower($provider)) {
                $availgOptions[] = $providerInstance->cancelPickup($options);
                return $availgOptions;
            }
        }

        return [
            'status' => 'error',
            'message' => "Provider '$provider' not found.",
        ];
    }

    public static function returnShipment(array $options, string $provider): array
    {
        $providers = self::getAllProviders();
        $availgOptions = [];

        foreach ($providers as $key => $providerInstance) {
            if (strtolower($key) === strtolower($provider)) {
                $availgOptions[] = $providerInstance->returnShipment($options);
                return $availgOptions;
            }
        }

        return [
            'status' => 'error',
            'message' => "Provider '$provider' not found.",
        ];
    }

    public static function cancelShipment(array $options, string $provider): array
    {
        $providers = self::getAllProviders();
        $availgOptions = [];

        foreach ($providers as $key => $providerInstance) {
            if (strtolower($key) === strtolower($provider)) {
                $availgOptions[] = $providerInstance->cancelShipment($options);
                return $availgOptions;
            }
        }

        return [
            'status' => 'error',
            'message' => "Provider '$provider' not found.",
        ];
    }

    public static function TrackShipment(array $options, string $provider): array
    {
        $providers = self::getAllProviders();
        $availgOptions = [];

        foreach ($providers as $key => $providerInstance) {
            if (strtolower($key) === strtolower($provider)) {
                $availgOptions[] = $providerInstance->trackShipment($options);
                return $availgOptions;
            }
        }

        return [
            'status' => 'error',
            'message' => "Provider '$provider' not found.",
        ];
    }
}
