<?php
namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Merchant;
use Illuminate\Support\Facades\Crypt;
use Carbon\Carbon;

class VendorController extends Controller
{
    //
   
    public function createVendor(Request $request)
    {
        // Validate input fields
        $request->validate([
            'vendor_id'     => 'required|integer',
            'merchant_key'  => 'required|string|max:100|unique:merchants',
            'merchant_iv'   => 'required|string|max:100|unique:merchants',
        ]);
    
        // Encrypt merchant_key and merchant_iv before saving
        $merchant = Merchant::create([
            'vendor_id'     => $request->vendor_id,
            'merchant_key'  => $request->merchant_key,
            'merchant_iv'   => Crypt::encryptString($request->merchant_iv),
            'created_at'    => Carbon::now(),
            'updated_at'    => Carbon::now(),
        ]);
    
        return response()->json([
            'status'  => 'success',
            'message' => 'Merchant created successfully',
            'data'    => $merchant
        ]);
    }
    
}
