<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Api\BaseController;
use Illuminate\Http\Request;
use App\Models\Merchant;
use App\Traits\ResponseTrait;

class LoginController extends BaseController
{
    use ResponseTrait;

    public function login(Request $request)
    {
        // Validate the request with JSON response
        $validator = \Validator::make($request->all(), [
            'merchant_key' => 'required|string|exists:merchants,merchant_key',
            'merchant_iv'  => 'required|string|exists:merchants,merchant_iv',
        ]);

        if ($validator->fails()) {
            return $this->sendResponse('error', 'Validation failed', $validator->errors(), 422);
        }
        // Find the merchant
        $merchant = Merchant::where([
            'merchant_key' => $request->merchant_key,
            'merchant_iv' => $request->merchant_iv
        ])->first();

        if (!$merchant) {
            return $this->sendResponse('error', 'Unauthorized access', null, 401);
        }

        // Create Passport token
        $token = $merchant->createToken('MerchantToken')->accessToken;

        return $this->sendResponse('success', 'Login successful', ['token' => $token]);
    }
}
