<?php
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\LoginController;
use App\Http\Controllers\Api\VendorController;
use App\Http\Controllers\Api\LogisticsController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

    Route::post('get-key', [LoginController::class, 'login'])->name('passport.token');
    Route::middleware(['auth:api'])->group(function () {
        Route::post('create-vendor', [VendorController::class, 'createVendor']);
        Route::post('/logistics/validate-address', [LogisticsController::class, 'validateAddress']);
        Route::post('/logistics/shipping-cost', [LogisticsController::class, 'calculateShippingCost']);
        Route::post('/logistics/track', [LogisticsController::class, 'trackShipment']);
        Route::post('/logistics/create-shipment', [LogisticsController::class, 'createShipment']);
        Route::post('/logistics/create-pickup', [LogisticsController::class, 'createPickup']);
        Route::post('/logistics/return-shipment', [LogisticsController::class, 'returnShipment']);
        Route::post('/logistics/all-shipping-costs', [LogisticsController::class, 'getAllShippingCosts']);
        Route::post('/logistics/cancel-shipment', [LogisticsController::class, 'cancelShipment']);
        Route::post('/logistics/cancel-pickup', [LogisticsController::class, 'cancelPickup']);
        Route::post('/logistics/availablity-check', [LogisticsController::class, 'availablityCheck']);
        Route::post('/logistics/pickup-availablity-check', [LogisticsController::class, 'pickupAvailability']);
        Route::post('/logistics/create-delhivery-warehouse', [LogisticsController::class, 'createDelhiveryWarehouse']);
    });


