<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Traits\ResponseTrait;
class WhitelistIP
{
    use ResponseTrait; // Use the trait
    private $whitelist = ['192.168.1.1', '127.0.0.1']; // Allowed IPs

    public function handle($request, Closure $next)
    {
       
        if (!in_array($request->ip(), $this->whitelist)) {
            //return response()->json(['message' => 'Unauthorized IP'.$request->ip()], 403);
            return $this->sendResponse('error', 'Unauthorized IP', null, 403);
        }
        return $next($request);
    }
}
