<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\Merchant;
use Illuminate\Support\Facades\Crypt;

class VendorRegistrationController extends Controller
{
    public function storeMerchantKeys($vendorId, $key, $iv)
        {
            Merchant::updateOrCreate(
                ['vendor_id' => $vendorId],
                [
                    'merchant_key' => Crypt::encryptString($key), // Encrypt key
                    'merchant_iv'  => Crypt::encryptString($iv)  // Encrypt IV
                ]
            );
        }
    public function getMerchantKeys($vendorId)
        {
            $merchant = Merchant::where('vendor_id', $vendorId)->first();
        
            if (!$merchant) {
                return null;
            }
        
            return [
                'merchant_key' => Crypt::decryptString($merchant->merchant_key),
                'merchant_iv'  => Crypt::decryptString($merchant->merchant_iv),
            ];
        }
}
