<?php
namespace App\Helpers;

use App\Models\Merchant;
use Illuminate\Support\Facades\Crypt;

class SecurityHelper
{
    public static function encryptData($data, $vendorId)
    {
        $keys = getMerchantKeys($vendorId);

        if (!$keys) {
            throw new \Exception("Merchant keys not found");
        }

        return openssl_encrypt($data, 'AES-256-CBC', $keys['merchant_key'], 0, $keys['merchant_iv']);
    }

    public static function decryptData($encryptedData, $vendorId)
    {
        $keys = getMerchantKeys($vendorId);

        if (!$keys) {
            throw new \Exception("Merchant keys not found");
        }

        return openssl_decrypt($encryptedData, 'AES-256-CBC', $keys['merchant_key'], 0, $keys['merchant_iv']);
    }
}
