<?php

namespace App\Adapters\Shipping;

class UpsAdapter
{
    public static function buildUpsAddress(array $input): array
    {
        return [
            "XAVRequest" => [
                "AddressKeyFormat" => [
                    "ConsigneeName"         => $input['company_name'] ?? '',
                    "BuildingName"          => $input['building_name'] ?? '',
                    "AddressLine"           => $input['street'],
                    "Region"                => "{$input['city']},{$input['state']},{$input['postal_code']}",
                    "PoliticalDivision2"    => $input['city'],
                    "PoliticalDivision1"    => $input['state'],
                    "PostcodePrimaryLow"    => $input['postal_code'],
                    "PostcodeExtendedLow"   => $input['postal_code_ext'] ?? '',
                    "Urbanization"          => '',
                    "CountryCode"           => $input['country'],
                ]
            ]
        ];
    }
}
